// By EVOLVED
// www.evolved-software.com

//--------------
// tweaks
//--------------
  float4 FilterValue;
  float SeedValue;

//--------------
// Textures
//--------------
   texture TerrainTexture <string Name = "";>;
   sampler TerrainSampler=sampler_state
      {
 	Texture=<TerrainTexture>;
 	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
     	ADDRESSU=Clamp;
        ADDRESSV=Clamp;
        ADDRESSw=Clamp;
      };

//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
 	float2 Tex:TEXCOORD0;
     };
   struct OutPut
     {
	float4 Pos:POSITION; 
 	float2 Tex1:TEXCOORD0;
	float2 Tex2:TEXCOORD1;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.Pos=IN.Pos;  
 	OUT.Tex1=(float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5;
	OUT.Tex2=((OUT.Tex1+FilterValue.xy)*FilterValue.z);
	return OUT;
     }

//--------------
// pixel shader
//--------------
   float2 mod(in float2 x, in float2 y)
      {
         return x-y*floor(x/y);
      }
   float4 PS_Noise(OutPut IN) : COLOR
      {
         float Noise=0.0;
    	 float Noisea=1.0;
    	 float Noiset=0.0;
    	 float2 Noisec=IN.Tex2;
     	 for (int i=0; i<FilterValue.w;i++) {
    	  float2 a=frac(Noisec);
    	  float2 b=floor(Noisec)*float2(0.3183099,0.3678794)+float2(0.3678794,0.3183099);
    	  b=frac(SeedValue*float2(0.3183099,0.3678794)*frac(b.x*b.y*(b.x+b.y)));
    	  float na=dot(-1.0+2.0*b,a);
	  b=(floor(Noisec)+float2(1,0))*float2(0.3183099,0.3678794)+float2(0.3678794,0.3183099);
    	  b=frac(SeedValue*float2(0.3183099,0.3678794)*frac(b.x*b.y*(b.x+b.y)));
    	  float nb=dot(-1.0+2.0*b,a-float2(1.0,0.0));
    	  b=(floor(Noisec)+float2(0.0,1.0))*float2(0.3183099,0.3678794)+float2(0.3678794,0.3183099);
    	  b=frac(SeedValue*float2(0.3183099,0.3678794)*frac(b.x*b.y*(b.x+b.y)));
    	  float nc=dot(-1.0+2.0*b,a-float2(0.0,1.0));
	  b=(floor(Noisec)+float2(1,1))*float2(0.3183099,0.3678794)+float2(0.3678794,0.3183099);
    	  b=frac(SeedValue*float2(0.3183099,0.3678794)*frac(b.x*b.y*(b.x+b.y)));
    	  float nd=dot(-1.0+2.0*b,a-float2(1.0,1.0));
    	  float2 m=a*a*a*(a*(a*6-15.0)+10.0);
   	  Noise +=(na+m.x*(nb-na)+m.y*(nc-na)+m.x*m.y*(na-nb-nc+nd))*Noisea;
       	  Noisec *= 2.0;
       	  Noiset +=Noisea;
       	  Noisea *= 0.5;
    	 }
	 float2 Height;
	 Height.x=pow((0.5+(Noise/Noiset)*0.5),2.0)*2.0;
	 Height.x *=255.0;
	 Height.y=frac(Height.x)*255.0;
	 return float4(floor(Height.xy)/255.0,0.0,0.0);
      }
   float4 PS_Worley(OutPut IN)  : COLOR
      {
	 float Noise=1.0;
         float2 Noisec=IN.Tex2;
         for (int k=0; k<9; k++) {
          for (int i=0 ; i<FilterValue.w; i++) {
           float2 Noiset=mod(floor(Noisec)+float2(k%3,k/3)-1.0,FilterValue.z);
           float2 Noisea=frac(52.9829*sin(57.8*mul(Noiset+i*0.1,float2x2(1,-13.17,377.1,-78.7))))*2.0-1.0;
           Noiset=0.5+Noiset+Noisea*0.5;
           Noiset=mod(Noiset-Noisec+FilterValue.z/2.0,FilterValue.z)-FilterValue.z/2.0;
           if(length(Noiset)<Noise) Noise=length(Noiset);
          }
         }
	 float2 Height;
         Height.x=max(1.0-exp(-Noise*5.0),0.0);
	 Height.x *=255.0;
	 Height.y=frac(Height.x)*255.0;
	 return float4(floor(Height.xy)/255.0,0.0,0.0);
      }
   float4 PS_Terrace(OutPut IN) : COLOR
      {
	 float2 Height=tex2D(TerrainSampler,IN.Tex1).xy;
	 Height.x *=255.0;
	 Height.x +=Height.y;
	 Height.x /=255.0;
         float a=frac((Height.x)*FilterValue.z);
         float b=floor((Height.x)*FilterValue.z);
         Height.x=((pow(a,FilterValue.w)-pow(1.0-a,FilterValue.w))/2.0)+(b+0.5);
         Height.x /=FilterValue.z;
	 Height.x *=255.0;
	 Height.y=frac(Height.x)*255.0;
	 return float4(floor(Height.xy)/255.0,0.0,0.0);
      }
   float4 PS_Erosion(OutPut IN) : COLOR
      {
 	 float2 Normals=(tex2D(TerrainSampler,IN.Tex1).wz*2-1)*float2(1,-1);
 	 float Slope=dot(Normals,Normals);
   	 float3 Height=0;
	 float HeightMask=0;
    	 float Heightc=1;
    	 float Heighta=1;
    	 float Heightt=0;
         for (int i=0;i<FilterValue.w;i++) {
          float2 a=floor(IN.Tex2*Heightc);
          float2 b=frac(IN.Tex2*Heightc);
          float3 va=0,wt=0;
          for (int x=-2; x<=1; x++) {
           for (int z=-2; z<=1; z++) {
            float2 xz=float2(x, z);
            float2 h=(a-xz)*float2(0.3183099,0.3678794)+float2(0.3183099,0.3678794);
            h=frac(SeedValue*float2(0.3183099,0.3678794)*frac(h.x*h.y*(h.x+h.y)));
            float2 pp=b+xz-(-1.0+2.0*h)*0.5;
            float d=dot(pp,pp);
            float w=exp(-d*2.0);
            wt +=w;
            float mag=dot(pp,Normals);
            va +=float3(cos(mag*6.28318530718),-sin(mag*6.28318530718)*(pp+Normals))*w;
           }
          }
          Height +=(va/wt)*Heighta*float3(1.0,Heightc,Heightc);
          HeightMask +=(va/wt);
	  Normals +=Height.zy*float2(-1.0,1.0);
	  Heightc *=2.0;
       	  Heightt +=Heighta;
          Heighta *=0.5;
         }
	 Height.x=0.5+(Height.x*Slope)*0.5;
	 Height.x *=255;
	 Height.y=frac(Height.x)*255;
	 return float4(floor(Height.xy)/255,0.5+HeightMask*Slope,0);
      }

//--------------
// techniques
//--------------
   technique Noise
      {
 	pass p1
      {	
 	vertexShader = compile vs_3_0 VS();
 	pixelShader  = compile ps_3_0 PS_Noise();
	zwriteenable=false;
	zenable=false;
	ZFunc=always;
      }
      }
   technique Worley
      {
 	pass p1
      {	
 	vertexShader = compile vs_3_0 VS();
 	pixelShader  = compile ps_3_0 PS_Worley();
	zwriteenable=false;
	zenable=false;
	ZFunc=always;
      }
      }
   technique Terrace
      {
 	pass p1
      {	
 	vertexShader = compile vs_3_0 VS();
 	pixelShader  = compile ps_3_0 PS_Terrace();
	zwriteenable=false;
	zenable=false;
	ZFunc=always;
      }
      }
   technique Erosion
      {
 	pass p1
      {	
 	vertexShader = compile vs_3_0 VS();
 	pixelShader  = compile ps_3_0 PS_Erosion();
	zwriteenable=false;
	zenable=false;
	ZFunc=always;
      }
      }
